package com.mentoring.asuper.geburtstagsreminder;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.hardware.SensorManager;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.Toast;

import java.io.File;

public class MainActivity extends AppCompatActivity {

    private PendingIntent pendingIntent;
    private AlarmManager manager;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        Intent alarmIntent = new Intent(this, ReminderAlarm.class);
        pendingIntent = PendingIntent.getBroadcast(this, 0, alarmIntent, 0);
    }

     public void createInputActivity(View v) {
        startActivity(new Intent(this, InputActivity.class));
    }

    public void start(View v) {
        manager = (AlarmManager) getSystemService(Context.ALARM_SERVICE);
        manager.setRepeating(AlarmManager.RTC_WAKEUP, System.currentTimeMillis(),
                60000, pendingIntent);
        Toast.makeText(this, "Geburtstagsreminder läuft", Toast.LENGTH_SHORT).show();
    }

    public void stop(View v) {
        if (manager != null) {
            manager.cancel(pendingIntent);
            Toast.makeText(this, "Geburtstagsreminder wurde gestoppt",
                    Toast.LENGTH_SHORT).show();
        }
    }

    public void deleteData(View v) {
        File dir = getFilesDir();
        File file = new File(dir, "myfile");
        boolean deleted = file.delete();
        if(deleted) {
            Toast.makeText(this, "Daten gelöscht", Toast.LENGTH_SHORT).show();
        } else {
            Toast.makeText(this, "Löschen der Daten fehlgschlagen", Toast.LENGTH_SHORT).show();
        }
    }

}
