import java.util.Locale;

import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.*;
import org.joda.time.*;

import java.util.*;  //für: .toString
import java.io.*;  //fürs speichern und so

import java.util.ArrayList;



public class datums_test {
 
 
    
    
    
 
 public static void main (String args[]) {
  
   String line = "19.06.2017 Beispiel Name";
   Integer leerzeichen_int = line.indexOf(" ");   //Finde das Leerzeichen im String "line"
   String dat_s = line.substring(0, leerzeichen_int);   //wir holen in dat_s das Datum, dafr kopieren wir alles bis zum Leerzeichen
   
   System.out.println("#länge: "+line.length() );
   System.out.println("#Leerzeichen an der Stelle: "+leerzeichen_int );
   
   String na  = line.substring(leerzeichen_int+1, line.length() );   //in den String "na" kopieren wir nun alles hinter dem Leerzeichen bis zum ende des Strings. Somit sollten wir den Namen haben
   System.out.println("#"+dat_s+"#");    //Ausgabe: #19.06.2017#
   System.out.println("#"+na+"#");       //Ausgabe: #Beispiel Name#
   
  DateTimeFormatter formatter = DateTimeFormat.forPattern("dd.MM.yyyy"); // Wir vereinbaren, wie wir das Datumsformat bergeben. Also mit Tag.Monat.Jahr jeweils mit Punkt getrennt
  DateTime dt = formatter.parseDateTime(dat_s); //wir parsen unser Datum. in der Variable "dt" haben wir nun unser Datum im Datumsformat
   
  DateTime aktDatum = new DateTime();   //Zum vergleich holen wir uns das aktuelle Datum
  //Wir probieren einige Beispiele aus:
  System.out.println("Aktuelle Jahr:                 " + aktDatum.getYear());
  System.out.println("Aktuelle Monat:                " + aktDatum.getMonthOfYear());
  System.out.println("Aktueller Tag des Monats:      " + aktDatum.getDayOfMonth());
   
  //Wir basteln uns nun ein neues Datum, welches aus dem Tag und Monat des bergebenen Geburtstages besteht, aber das aktuelle Jahr hat.
  int aktuelleJahr = aktDatum.getYear();
  int gebMonat = dt.getMonthOfYear();
  int gebTag   = dt.getDayOfMonth();
   
  //Wir machen daraus einen String:
  String gebDatumMitAktJahr_s = Integer.toString(gebTag) + "." + Integer.toString(gebMonat) + "." + Integer.toString(aktuelleJahr);
  DateTime gebDatumMitAktJahr = formatter.parseDateTime(gebDatumMitAktJahr_s);  //diesen String knnen wir nun parsen lassen, um eine Datumsvariable zu bekommen, mit der wir arbeiten knnen
   
  //System.out.println(">> " + gebDatumMitAktJahr_s);  //Zum Testen
   
  int alter = aktuelleJahr - dt.getYear();   //Wie alt ist diese Person?
   
  //Bei einem Datum haben wir eigentlich noch eine Uhrzeit dabei. Damit diese ignoriert wird und wir nur das Datum vergleichen, benutzen wir: withTimeAtStartOfDay
   if ( gebDatumMitAktJahr.withTimeAtStartOfDay().isEqual( aktDatum.withTimeAtStartOfDay() ) )
   {
    System.out.println(na + " hat heute Geburtstag und wird "+ alter +" Jahre alt");
   }
   else
   {
    if ( gebDatumMitAktJahr.isBefore( aktDatum ) )  //Der Geburtstag von der Person war schon, also das Datum des Geburtstages fr dieses Jahr liegt VOR dem aktuellen Datum
    {
      System.out.println("Der Geburtstag war schon in diesem Jahr. Wir mssen bis nchstes Jahr warten und addieren darum ein Jahr rauf. Dann knnen wir sagen, in wievielen Tagen die Person Geburtstag hat.");
      
     aktuelleJahr++;   //zum aktuellen Jahr, ein Jahr hinzufgen. Darum inkrementieren wir das aktuelle Jahr.
     gebDatumMitAktJahr_s = Integer.toString(gebTag) + "." + Integer.toString(gebMonat) + "." + Integer.toString(aktuelleJahr);  //Den Datums-String erneut machen
     gebDatumMitAktJahr = formatter.parseDateTime(gebDatumMitAktJahr_s);  //Datumsvariable neu machen.
    }
    
    int AnzahlDerTage = Days.daysBetween(aktDatum, gebDatumMitAktJahr).getDays();   //Wieviele Tage sind dazwischen?
    AnzahlDerTage++;  //Da es bei Null beginnt zu zhlen, mssen wir eins dazu addieren, um es in der "normalen" Lesart zu haben.
    
    if (AnzahlDerTage == 1)
    {
     System.out.println(na + " hat morgen Geburtstag");
    }
    else
    {
    System.out.println("Dauert noch... " +na + " hat erst in "+ AnzahlDerTage +" Tagen Geburtstag");
   }
   
   
   }
   
   
   
   
   
   save( aktDatum.toString() );  //Beispiel frs speichern in Java. Es wird das aktuelle Datum mit Zeit im Iso-Format gespeichert

   System.out.println();
   System.out.println("Ausgabe:");
   
  ArrayList<String> ausgabe = new ArrayList<String>();
  ausgabe = load_arrayList();   //Ein Beispiel frs laden in Jave und mit der bergabe als Arraylist
 
  System.out.println("Anzahl in der Liste: "+ ausgabe.size() );

  //Beispiel fr das Durchgehen und Ausgeben in dieser Liste:
  for (int i=0; i < ausgabe.size(); i++)
  {
   System.out.println("Zeile Nr. "+i+": "+ ausgabe.get(i));
  }
     
      
   
 }
 
 
 
 
 
 
 
 
 
 
 
 public static void save(String toSave) {
   try{
     //append
     FileWriter fw = new FileWriter("myfile.txt", true); //hier wird nur angehangen
     //soll es überschrieben werden, wrde man folgendes schreiben::
     //FileWriter fw = new FileWriter("myfile.txt");
     BufferedWriter bw = new BufferedWriter(fw);
     PrintWriter out = new PrintWriter(bw);
     out.println(toSave);
     out.close();
  }
  catch(Exception e){
   //erstmal nichts machen... Sollte aber ggf abgefangen werden...
  }
  
}
    
    

 
 //Beispiel frs einlesen in eine ArrayListe. Hier wird jede Zeile eingelesen und jede Zeile wird zur Arrayliste (einzeln) hinzugefgt.
 //Wir knnen dann also die ArrayListe einfach ansprechen und die Zeilen einzeln bekommen.
  public static ArrayList load_arrayList() {
       
       ArrayList<String> ret = new ArrayList<String>();
       
        try{
   
          File file = new File("myfile.txt");

          if (!file.canRead() || !file.isFile())
            System.exit(0); 
            
          FileReader fr = new FileReader(file);
          BufferedReader br = new BufferedReader(fr);
          String zeile = "";

          while( (zeile = br.readLine()) != null ) {
            ret.add(zeile);
          }

          br.close();
    
      }catch(Exception e){
        //erstmal nichts machen... Sollte aber ggf abgefangen werden...
      }
    
      return ret;
 }
    
    
    
//Beispiel frs Zeilenweise laden und alles wird in einem String zurckgegeben:
  public String load() {
    String ret = "";
        
    try{
      File file = new File("myfile.txt");

        if (!file.canRead() || !file.isFile())
            System.exit(0); 
            
            
    FileReader fr = new FileReader(file);
    BufferedReader br = new BufferedReader(fr);

    String zeile = "";

    while( (zeile = br.readLine()) != null ) {
      ret = ret + zeile;
    }

    br.close();
    
  }
  catch(Exception e) {
      //erstmal nichts machen... Sollte aber ggf abgefangen werden...
  }
    
 return ret;
 }
  
  
  
  
  
  
}

